%==========================================================================================
% This ver: 2021/10/16
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2021). Mixture-of-Lognormal 
%           Risk-Neutral Density Estimation Revisited: Asymptotics, Analytical Derivatives,
%           and the Mode Constraint
%========================================================================================== 


clearvars; clc;
%load the cross-section of call option prices (obtained by put-call parity
%using only out-of-the-money options) written on SPY with 1 month to expiry
%or 1 week to expiry
load('SPY_181019_1M.mat')
plot(strike,o_observe,'o')
grid on
xlabel('strike')
ylabel('call prices')
xline(Ft,'label','F_t','LineStyle','--');

%Set up options for RND estimation. Please see the function for available
%options and default choice
options=MLN_options();
%Estimate the MLN parameters with a maximum of 5 mixtures and 2 modes
[estpar_all,estpar_all_mc,estpar_info] = MLN_RND(o_observe,strike,rf,ttm,Ft, ...
    'call',5,2,options);

%Perform the sequential test to choose M
[M_opt,info] = MLN_sequential_test(estpar_all_mc,o_observe,strike,rf, ...
    ttm,Ft,'call',1,1,.01,true);

%Parameter estimates and RND estimates of the M-MLN model
xval=linspace(strike(1),strike(end),10000)';
 [residinfo,parminfo,RNDinfo] = MLN_RND_infer(estpar_all_mc(M_opt-1,:)', o_observe,...
     strike,rf,ttm,Ft,'call',xval,true);