function parm_vec = MLN_x0_gen(size_x0,M,strike,Ft,sig_start,TTM, ...
    n_mode,n_mode_step)
%==========================================================================================
%This function generates random initial parameter vectors for the M-MLN
%density, which satisfy both parameter constraints and the mode constraint
%
%INPUT:
%     size_x0: number of parameter vector to be generated for the
%              pre-filter step
%           M: number of mixtures
%      strike: the strike grid
%          Ft: the spot forward price
%   sig_start: at-the-money Black-Scholes implied volatility
%         TTM: time to maturity
%      n_mode: maximum number of modes
% n_mode_step: number of points to evaluate the mode constraint
%
%OUTPUT:
%   parm_vec: (3M-2)-by-size_x0 parameter vectors. Each column contains one set
%   of initial parameter values of the following structure:
%  [sigma^(1), ... , sigma^(M), w^(1), ... , w^(M-1), F^(1), F^(2), ... , F^(M-1)]
%==========================================================================================
% This ver: 2021/10/16
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2021). Mixture-of-Lognormal 
%           Risk-Neutral Density Estimation Revisited: Asymptotics, Analytical Derivatives,
%           and the Mode Constraint
%========================================================================================== 
parm_vec=[];
c=0;
while c < size_x0
    w=0.1+0.8*rand(M,1);
    w=w./sum(w);
    sr=[strike(1) strike(end)];
    F=sr(1)+(sr(2)-sr(1))*rand(M-1,1);
    F=[F ;  (Ft-sum(w(1:M-1).*F))./w(end)];
    sig=sig_start*(0.5+rand(M,1));
    parm_full=MLN_parm_sort([w;F;sig],2);
    parm=MLN_parm_convert(parm_full);
    if F(end) > 0 && all(MLN_nlcon(parm,Ft,TTM,n_mode,n_mode_step)<=0)
        parm_vec=[parm_vec parm];
    end
    [~,c]=size(parm_vec);
end




