function par_ext = MLN_parm_extend(estpar,Ft,sig_0)
%==========================================================================================
%This function extend the 3M-by-1 parameter vector into the (3M+1)-by-1
%parameter as initial value for the estimation of the (M+1)-MLN mixture
%model
%
%INPUT:
%   estpar: 3M-by-1 vector of parameter 
%   Ft    : spot futures price
%   sig_0 : at-the-money Black-Scholes implied volatility
%
%OUTPUT:
%   par_ext: (3(M+1)-2)-by-1 vector of parameters, used as the initial
%            value of the very first local estimation step of the (M+1)-MLN
%            density
%==========================================================================================
% This ver: 2021/10/16
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2021). Mixture-of-Lognormal 
%           Risk-Neutral Density Estimation Revisited: Asymptotics, Analytical Derivatives,
%           and the Mode Constraint
%========================================================================================== 

M=length(estpar)/3;

if floor(M)~=M
 error('estpar must be a 3M-by-1 vector.')
end

estpar=MLN_parm_sort(estpar,1,Ft);
par_ext=[estpar(1:M); 0; estpar(M+1:2*M); Ft; estpar(2*M+1:3*M);sig_0];
par_ext=MLN_parm_convert(par_ext);

end

