function parm = MLN_parm_convert(parm_0,Ft)
%==========================================================================================
%This function convert the 3M-by-K parameter vector to the (3M-2)-by-K
%version, or the other way around, depending on the dimension of parm_0.
%Format of the 3M-2 version (per row)
%  [sigma^(1), ... , sigma^(M), w^(1), ... , w^(M-1), F^(1), F^(2), ... , F^(M-1)]
%Format of the 3M version (per row)
%  [w^(1), ... , w^(M), F^(1), F^(2), ... , F^(M),sigma^(1), ... , sigma^(M)]
%==========================================================================================
% This ver: 2021/10/16
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2021). Mixture-of-Lognormal 
%           Risk-Neutral Density Estimation Revisited: Asymptotics, Analytical Derivatives,
%           and the Mode Constraint
%========================================================================================== 

[T,~]=size(parm_0);
if mod(T,3)==1
    M=ceil(T/3);
    w_vec = [parm_0(1+M:2*M-1,:); 1 - sum(parm_0(1+M:2*M-1,:),1)];
    f_vec = [parm_0(2*M:end,:); (Ft - sum(parm_0(2*M:end,:).*w_vec(1:end-1,:),1))./w_vec(end,:)];
    f_vec(isnan(f_vec))=Ft;
    sigma_vec = parm_0(1:M,:);
    parm=[w_vec; f_vec; sigma_vec];
elseif mod(T,3)==0
    M=T/3;
    parm=[parm_0(2*M+1:end,:);parm_0(1:M-1,:);parm_0(M+1:2*M-1,:)];
else
    error('The input must have either 3M rows or 3M-2 rows');
end

