function options = MLN_options(varargin)
%==========================================================================================
%This function sets the options for the MLN_RND function.
%If no inputs are provided, the function returns all default options.
%
%The inputs of the function are the following string-value pair:
%   
%   analyticGrad:   specify whether to use analytical gradient. Default = true
%   analyticHess:   specify whether to use analytical Hessian. Default = true
%   n_mode_step:    the number of steps to evaluate the second-order
%                   derivative on the interval [A-,A+]. Default = 1e4
%   max_time_iter:  maximum running time in seconds for each local optimization.
%                   Default = 10
%   max_time_M:     maximum running time in seconds for each M in the global
%                   optimization. Default = 600
%   Nbest_max:      maximum number of feasible local minima to accumulate in the
%                   estimation. Default = 10
%   Display:        set Display = 'off' suppresses all messages printed to
%                   the command window. Display = 'global' (default) prints to the
%                   command window after every global estimation. Display =
%                   'local' prints to the command window after every local
%                   estimation.
%==========================================================================================
% This ver: 2021/10/16
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2021). Mixture-of-Lognormal 
%           Risk-Neutral Density Estimation Revisited: Asymptotics, Analytical Derivatives,
%           and the Mode Constraint
%========================================================================================== 

%Setting default options
options = struct;
options.analyticGrad = true;
options.analyticHess = true;
options.n_mode_step = 1e4;
options.max_time_iter = 10;
options.max_time_M = 600;
options.Nbest_max = 10;
options.Display = 'global';


pvPairs = varargin;
optionlist={'analyticGrad','analyticHess','n_mode_step', ...
    'max_time_iter','max_time_M','Nbest_max','Display'};
for i = 1:2:length(pvPairs)
    if ischar(pvPairs{i}) || (isstring(pvPairs{i}) && isscalar(pvPairs{i}))
        if ismember(pvPairs{i},optionlist)
            options.(pvPairs{i}) = pvPairs{i+1};
        else
            error('Option not supported.')
        end
    end
end
end

