function Hout = MLN_hessFcn(x,lambda,nmixture,oprice,K, rf, TTM,ft, o_type)
%=====================================================================
% this function returns the Hessian for the fmincon estimation
% effectively, a wrapper function of MLN_Hessian
%=====================================================================
% This ver: 2021/10/16
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2021). Mixture-of-Lognormal 
%           Risk-Neutral Density Estimation Revisited: Asymptotics, Analytical Derivatives,
%           and the Mode Constraint
%=====================================================================

[~,~,H]= MLN_MSE(x,nmixture,oprice,K, rf, TTM,ft, o_type, false, true);

% Hessian of nonlinear inequality constraint
% w_1*F_1 + ... + w_{M-1}*F_{M-1} - F0 <= 0
% here, x = [sigma_1, ..., sigma_M, w_1, ..., w_{M-1}, F_1, ..., F_{M-1}]'
Hg = sparse(zeros(length(x)));
w_range = nmixture+1:2*nmixture-1;
F_range = 2*nmixture:length(x);
Hg(F_range,w_range) = eye(nmixture-1);
Hg(w_range,F_range) = eye(nmixture-1);

% mode constraint: hess = 0
Hm = sparse(zeros(length(x)));

Hout = H + lambda.ineqnonlin(1)*Hg + lambda.ineqnonlin(2)*Hm;

end
