function JO = MLN_OptionGrad_f(estpar,strike,rf,TTM,o_type)
%==========================================================================================
% Function to compute analytic gradient of option prices w.r.t. the
% parameter vector
%
% INPUT:
%   estpar: 3M-by-1 parameter vector
%   strike: N-by-1 vector of strike grid
%   rf:   scalar, risk-free rate
%   TTM: time to maturity of the options (in years)
%   o_type: type of option, 'call' or 'put'.
%
% OUTPUT:
%   JO: the N-by-3M Jacobian matrix of option prices w.r.t. estpar
%==========================================================================================
% This ver: 2021/10/16
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2021). Mixture-of-Lognormal 
%           Risk-Neutral Density Estimation Revisited: Asymptotics, Analytical Derivatives,
%           and the Mode Constraint
%========================================================================================== 

M =length(estpar)/3;
wvec = estpar(1:M);
fvec = estpar(M+1:2*M);
sigvec = estpar(2*M+1:end);
[fprices,delta,vega]= BS1_f(fvec','forward',strike,rf,0,TTM,sigvec',o_type,true,false);
JO=[fprices wvec'.*delta  wvec'.*vega];

end
