function p1 = MLN_FFF(grid,p,q)
%==========================================================================================
%This function constructs the flexible Fourier regressors for the
%auxiliary regression in Eq. (22) of Li, Nolte and Pham (2021)
%
%INPUT:
%       grid: N-by-1 vector of log-moneyness defined as log(strike/F_t)
%          p: order of polynomial
%          q: order of the Fourier series
%
%OUTPUT:
%         p1: N-by-(p+2q+1) matrix of regressors
%==========================================================================================
% This ver: 2021/10/16
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2021). Mixture-of-Lognormal 
%           Risk-Neutral Density Estimation Revisited: Asymptotics, Analytical Derivatives,
%           and the Mode Constraint
%========================================================================================== 


p1=[];
for i=0:p
    p1=[p1 grid.^i];
end
for i=1:q
    p1=[p1 cos(grid.*2.*pi.*i) sin(grid.*2.*pi.*i)];
end
end

